<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Honoraires extends Model 
{

    protected $table = 'honoraires';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function professeurs()
    {
        return $this->belongsToMany('App\Models\Professeur');
    }

    public function lecons()
    {
        return $this->morphedByMany('App\Models\Lecon', 'honoraireable');
    }

    public function matieres()
    {
        return $this->morphedByMany('App\Models\Matiere', 'honoraireable');
    }

    public function salaires()
    {
        return $this->belongsToMany('App\Models\FacturesProfesseurs');
    }

}